; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10

;---------------------------------------------------------------------------
;Artificial Intelligence
;---------------------------------------------------------------------------

;-|-AI-|--------------------------------------------------------------------
[Command]
name = "AI_1"
command = a, x, F, D, a, a, D
time = 1

[Command]
name = "AI_2"
command = a, a, a, a, a, a, b
time = 1

[Command]
name = "AI_3"
command = a, a, b, D, F, b, x
time = 1

[Command]
name = "AI_4"
command = y, a, F, b, B, y, a
time = 1

[Command]
name = "AI_5"
command = a, b, x, y, y, b, b
time = 1

[Command]
name = "AI_6"
command = b, y, y, F, b, B, B
time = 1

[Command]
name = "AI_7"
command = a, y, F, a, x, a, F, b
time = 1

[Command]
name = "AI_8"
command = a, a, b, y, x, B, x
time = 1

[Command]
name = "AI_9"
command = x, x, a, F, F, b, D
time = 1

[Command]
name = "AI_10"
command = x, x, a, F, y, a, a, F
time = 1

[Command]
name = "AI_11"
command = a, b, a, x, a, y, a
time = 1

[Command]
name = "AI_12"
command = b, y, a, F, y, a, x
time = 1

[Command]
name = "AI_13"
command = x, a, y, y, x, B, B
time = 1

[Command]
name = "AI_14"
command = a, F, F, x, B, F, x
time = 1

[Command]
name = "AI_15"
command = y, x, b, b, a, x, y
time = 1

[Command]
name = "AI16"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI17"
command = a,B,c,x,y,z,s,B,D,F,U,a,b,c,x,y,z,s,s
time = 0
[Command]
name = "AI18"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI19"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 0
[Command]
name = "AI20"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI21"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI22"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI23"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI24"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI25"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI26"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI27"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI28"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI29"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI30"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI31"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI32"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI33"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI34"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI35"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI36"
command = z,z,z,z,z,z,a,a,a,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI37"
command = z,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,z,z,z
time = 0
[Command]
name = "AI38"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z
time = 0
[Command]
name = "AI39"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI40"
command = z,z,z,z,a,a,a,z,z,z,z,a,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI41"
command = z,z,z,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z,z
time = 0
[Command]
name = "AI42"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI43"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,a,a,z
time = 0
[Command]
name = "AI44"
command = z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,a,a,a,z
time = 0
[Command]
name = "AI45"
command = z,z,z,z,z,z,a,a,z,z,z,z,z,a,a,a,a,z,z
time = 0
[Command]
name = "AI46"
command = z,z,z,z,z,z,z,z,a,a,a,a,a,a,z,z,z,z,z
time = 0
[Command]
name = "AI47"
command = z,z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI48"
command = z,z,z,z,z,a,a,a,z,z,z,a,a,a,z,z,a,z,a
time = 0
[Command]
name = "AI49"
command = z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z,z
time = 0
[Command]
name = "AI50"
command = z,z,z,a,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z
time = 0

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;

;-| Breaker, Hit Thech |----------------------------------------------------
[Command]
name = "Breaker"
command = x+y+a+b
time = 15

[Command]
name = "Hit Tech"
command = y+b+z+c
time = 15

;---------------------------------------------------------------------------

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, x+y
time = 20

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, x+z
time = 20

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, y+z
time = 20

[Command]
name = "QCF_ab"
command = ~D, DF, F, a+b

[Command]
name = "QCF_ab"
command = ~D, DF, F, a+c

[Command]
name = "QCF_ab"
command = ~D, DF, F, b+c

[Command]
name = "Suicide Bombing"
command = ~D, DB, B, a+b

[Command]
name = "Suicide Bombing"
command = ~D, DB, B, a+c

[Command]
name = "Suicide Bombing"
command = ~D, DB, B, b+c

;-| Special Motions |------------------------------------------------------
[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

[Command]
name = "Surprise!"
command = ~D, DB, B, x

[Command]
name = "Surprise!"
command = ~D, DB, B, y

[Command]
name = "Surprise!"
command = ~D, DB, B, z

[Command]
name = "Teleport Left"
command = ~D, DB, B, a

[Command]
name = "Teleport Med"
command = ~D, DB, B, b

[Command]
name = "Teleport Right"
command = ~D, DB, B, c

[Command]
name = "Air Bomb"
command = ~D, DF, F, x

[Command]
name = "Air Bomb"
command = ~D, DF, F, y

[Command]
name = "Air Bomb"
command = ~D, DF, F, z

[Command]
name = "Yojimbo Slash"
command = ~F, D, DF, x

[Command]
name = "Yojimbo Slash"
command = ~F, D, DF, y

[Command]
name = "Yojimbo Slash"
command = ~F, D, DF, z

[Command]
name = "Magnum 1"
command = ~F, D, DF, a

[Command]
name = "Magnum 2"
command = ~F, D, DF, b

[Command]
name = "Magnum 3"
command = ~F, D, DF, c


[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

;-| Guard Push | ---------------------------------------------------------- \
[Command]
name = "GuardPush1";Required (do not remove)
command = x+y
time = 10

[Command]
name = "GuardPush2";Required (do not remove)
command = y+z
time = 10

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "super_jump_up"
command = ~D, U
time = 50

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;-|-AI-|--------------------------------------------------------------------
[State -1, AI]
type = null;VarSet
trigger1 = command = "AI_1"
trigger2 = command = "AI_2"
trigger3 = command = "AI_3"
trigger4 = command = "AI_4"
trigger5 = command = "AI_5"
trigger6 = command = "AI_6"
trigger7 = command = "AI_7"
trigger8 = command = "AI_8"
trigger9 = command = "AI_9"
trigger10 = command = "AI_10"
trigger11 = command = "AI_11"
trigger12 = command = "AI_12"
trigger13 = command = "AI_13"
trigger14 = command = "AI_14"
trigger15 = command = "AI_15"
v = 59
value = 1
;===========================================================================









;===========================================================================
;                             AI COMMAND
;===========================================================================


;---------------------------------------------------------------------------
;Suicide Bombing
[State -1, Suicide Bombing]
type = ChangeState
value = 3200
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
triggerall = ctrl
triggerall = P2bodydist X = [-98,91]
triggerall = enemynear,Pos Y > -157
triggerall = enemynear,vel Y > -1
triggerall = random < 100
triggerall = Life > Lifemax/2
trigger1 = enemynear,movetype = A
trigger2 = enemynear,vel X > 5

;---------------------------------------------------------------------------
;Yojimbo Slash
[State -1, Yojimbo Slash]
type = ChangeState
value = 1200
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
triggerall = enemynear,Pos Y > -95
triggerall = enemynear,vel Y > -1
trigger1 = P2bodydist X = [-1,51] ;51]
trigger1 = random < 20
trigger2 = P2bodydist X = [90,140] ;51]
trigger2 = random < 70

;---------------------------------------------------------------------------
[State -1, Throw]
type = ChangeState
value = 800
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,statetype != L
trigger1 = ctrl
trigger1 = P2bodydist X = [-1,20]
trigger1 = random < 40


;===========================================================================
;GUARD/BLOCK CODE
;===========================================================================

[State -1, standGuard]
type = ChangeState
triggerall = var(59)>=1 && random <= 150 && StateNo != 130
triggerall =(StateType != A) && (Ctrl)&& (enemynear, Facing != Facing)
trigger1 = (P2StateType != C) ;&& (P2MoveType = A)
trigger1 = inguarddist
value = 130

[State -1, airGuardHitBack]
type = ChangeState
triggerall = var(59)>=1 && random <= 150
triggerall =(StateType != A) && (enemynear, Facing != Facing)
triggerall = (P2StateType = C) ;&& (P2MoveType = A)
trigger1 = StateNo = 150
;trigger2 = inguarddist
value = 152

[State -1, crouchGuarde]
type = ChangeState
triggerall = var(59)>=1 && random <= 150 && StateNo != 131
triggerall = (StateType != A) && (Ctrl) && (enemynear, Facing != Facing)
trigger1 = (P2StateType = C) ;&& (P2MoveType = A)
trigger1 = inguarddist
value = 131

[State -1, standGuardHitBack]
type = ChangeState
triggerall = var(59)>=1 && random <= 150
triggerall =(StateType != A) && (enemynear, Facing != Facing)
triggerall = (P2StateType != C) ;&& (P2MoveType = A)
trigger1 = StateNo = 152
;trigger2 = inguarddist
value = 150

[State -1, airGuard]
type = ChangeState
triggerall = var(59)>=1 && random <= 150 && StateNo != 132
triggerall = (StateType = A) ;&& (Ctrl) && (enemynear, Facing != Facing)
trigger1 = P2MoveType = A
trigger1 = inguarddist
value = 132




;==========================================================================

;---------------------------------------------------------------------------
;Bullet Fury
[State -1, Bullet Fury]
type = ChangeState
value = 3000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = P2bodydist X > 140
trigger1 = enemynear,Pos Y > -160
trigger1 = enemynear,vel Y > -1
trigger1 = random < 40

;---------------------------------------------------------------------------
;Fake Gamma Charge
[State -1, Fake Gamma Charge]
type = ChangeState
value = 3100
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = P2bodydist X > 121
trigger1 = enemynear,Pos Y > -148
trigger1 = enemynear,vel Y > -1
trigger1 = random < 40



;---------------------------------------------------------------------------
;Crouch_A
[State -1, Crouch_X]
type = ChangeState
value = 430
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,statetype != A
triggerall = P2bodydist X = [-1,65]
trigger1 = ctrl
trigger1 = random >= 938
trigger2 = stateno = 200 && moveguarded
trigger3 = stateno = 230 && moveguarded

;---------------------------------------------------------------------------
;Stand_X
[State -1, Stand_X]
type = ChangeState
value = 200
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,65]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -93
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50

;---------------------------------------------------------------------------
;Stand_A
[State -1, Stand_A]
type = ChangeState
value = 230
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,65]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -93
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50

;---------------------------------------------------------------------------
;Stand_B
[State -1, Stand_B]
type = ChangeState
value = ifelse(Life<=Lifemax/2,240,420)
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [-1,85]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -166
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50 && enemynear,statetype != A || random < 25 && enemynear,statetype = A 
trigger2 = enemynear,statetype = A
trigger2 = stateno = 200 || stateno = 230
trigger2 = movecontact
trigger3 = enemynear,statetype != A
trigger3 = stateno = 200 || stateno = 230 || stateno = 430
trigger3 = movehit

;---------------------------------------------------------------------------
;Crouch_X
[State -1, Crouch_X]
type = ChangeState
value = 400
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,65]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -93
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50

;---------------------------------------------------------------------------
;Stand_Y
[State -1, Stand_Y]
type = ChangeState
value = 210
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,108]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -93
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50

;---------------------------------------------------------------------------
;Super Jump Up -> Air Combo
[State -1, Super Jump Up -> Air Combo]
type = ChangeState
value = 60
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
trigger1 = stateno = 240 && movehit
trigger1 = random < 600

;---------------------------------------------------------------------------
;Overhead Attack
[State -1, Overhead Attack]
type = ChangeState
value = 260
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = P2bodydist X = [-1,130]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -84
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50

;---------------------------------------------------------------------------
;Crouch_Y
[State -1, Crouch_Y]
type = ChangeState
value = 410
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [-1,100]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -70
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50
trigger2 = stateno = 400 && movecontact

;---------------------------------------------------------------------------
;Crouch_B
[State -1, Crouch_B]
type = ChangeState
value = 240
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [-1,70]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -55
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50
trigger2 = stateno = 400 || stateno = 430
trigger2 = moveguarded

;---------------------------------------------------------------------------
;Crouch_Z
[State -1, Crouch_Z]
type = ChangeState
value = 420
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [-1,120]
trigger1 = ctrl
trigger1 = enemynear,Pos Y > -70
trigger1 = enemynear,vel Y > -1
trigger1 = random < 50
trigger2 = stateno = 410 && movecontact
trigger2 = time >= 31



;---------------------------------------------------------------------------
;Stand Z
[State -1, Stand Z]
type = ChangeState
value = 220
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X = [70,110]
trigger1 = enemynear,Pos Y > -100
trigger1 = enemynear,vel Y > -1
trigger1 = ctrl
trigger1 = random < 50
trigger2 = stateno = 210 && movecontact

;---------------------------------------------------------------------------
;Surprise!
[State -1, Surprise!]
type = ChangeState
value = 1100
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = enemynear,movetype != H
trigger1 = P2bodydist X = [80,165]
trigger1 = enemynear,statetype != A
trigger1 = ctrl
trigger1 = random < 75

;---------------------------------------------------------------------------
;Gunfire 1
[State -1, Gunfire 1]
type = ChangeState
value = 1000
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X > 140
trigger1 = enemynear,Pos Y > -100
trigger1 = enemynear,vel Y > -1
trigger1 = ctrl
trigger1 = random < 25

;---------------------------------------------------------------------------
;Gunfire 2
[State -1, Gunfire 2]
type = ChangeState
value = 1010
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X > 160
trigger1 = enemynear,Pos Y > -120
trigger1 = enemynear,vel Y > -1
trigger1 = ctrl
trigger1 = random < 25

;---------------------------------------------------------------------------
;Gunfire 3
[State -1, Gunfire 3]
type = ChangeState
value = 1020
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = numhelper(1024) < 2
trigger1 = P2bodydist X > 140
trigger1 = ctrl
trigger1 = random < 20

;---------------------------------------------------------------------------
;Crouch C
[State -1, Crouch C]
type = ChangeState
value = 450
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = numhelper(451) < 1
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X > 140
trigger1 = ctrl
trigger1 = random < 20

;---------------------------------------------------------------------------
;Magnum 2
[State -1, Magnum 2]
type = ChangeState
value = 1500
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
trigger1 = enemynear,statetype!= A
trigger1 = P2bodydist X = [160,260]
trigger1 = random < 25

;---------------------------------------------------------------------------
;Magnum 3
[State -1, Magnum 3]
type = ChangeState
value = 1510
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
triggerall = ctrl
trigger1 = enemynear,statetype!= A
trigger1 = P2bodydist X = [170,320]
trigger1 = random < 25


;---------------------------------------------------------------------------
;Teleport Left
[State -1, Teleport Left]
type = ChangeState
value = 1300
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
trigger1 = ctrl
trigger1 = P2bodydist X = [0,85]
trigger1 = random < 25
trigger2 = stateno = 420 && animtime = -1
trigger2 = movehit || moveguarded && enemynear,statetype = A

;---------------------------------------------------------------------------
;Teleport Right
[State -1, Teleport Right]
type = ChangeState
value = 1320
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = P2bodydist X > 60
trigger1 = ctrl
trigger1 = random < 30

;---------------------------------------------------------------------------
;Air Bomb
[State -1, Teleport Right]
type = ChangeState
value = 1400
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = ctrl
trigger1 = P2bodydist X = [-1,160]
trigger1 = Pos Y < -120
trigger1 = random < 50


;===========================================================================

;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
triggerall = enemynear,statetype != L
triggerall = enemynear,stateno != [5100,5120]
triggerall = enemynear,anim!=5120
trigger1 = ctrl
trigger1 = P2bodydist X > 65
trigger1 = random >= 900

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
trigger1 = ctrl
trigger1 = P2bodydist X = [0,70]
trigger1 = random < 25

;---------------------------------------------------------------------------
;Walk Fwd 
[State -1, Walk Fwd]
type = ChangeState
value = 28
triggerall = RoundState = 2 && var(59)
triggerall = StateType != A
trigger1 = ctrl
trigger1 = P2bodydist X > 110

;===========================================================================

;---------------------------------------------------------------------------
;Air_X
[State -1, Air_X]
type = ChangeState
value = 600
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
triggerall = P2bodydist X = [-1,70]
trigger1 = stateno = 61
trigger2 = P2bodydist Y = [-10,10]
trigger2 = ctrl

;---------------------------------------------------------------------------
;Air_Z
[State -1, Air_Z]
type = ChangeState
value = 620
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = ctrl
trigger1 = P2bodydist X = [-1,130]
trigger1 = P2bodydist Y = [-1,100]
trigger1 = random < 75

;---------------------------------------------------------------------------
;Air_B
[State -1, Air_B]
type = ChangeState
value = 640
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = stateno = 600 && movecontact

;---------------------------------------------------------------------------
;Air_C
[State -1, Air_C]
type = ChangeState
value = 650
triggerall = RoundState = 2 && var(59)
triggerall = StateType = A
trigger1 = stateno = 640 && movecontact

;------------------------------------------------------------------------------
;Recover Rolls
[state -1, recover F]
type = changestate
value = 890
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
triggerall = random < 50
trigger1 = P2bodydist X > 140
trigger2 = P2bodydist x = [-10,70]
trigger2 = frontedgedist > 50 
trigger3 = inguarddist
trigger3 = frontedgedist > 50 
trigger4 = enemynear,numproj > 0
trigger4 = frontedgedist > 50 

[state -1, recover B]
type = changestate
value = 895
triggerall = var(59) 
triggerall = RoundState = 2
TriggerAll = alive 
Triggerall = stateno = 5120
triggerall = frontedgedist <= 50
triggerall = random < 50
trigger1 =  P2bodydist x = [-10,70]
trigger2 = inguarddist 
trigger3 = enemynear,numproj > 0




;===========================================================================
;                                 MANUAL
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;Combo Breaker
[State -1, Combo Breaker]
type = ChangeState
value = 3890
triggerall = !var(59)
triggerall = var(56) >= 1000
triggerall = movetype = H && alive 
triggerall = stateno != [120,155]
triggerall = stateno != [464,484]
triggerall = stateno != [5800,5831]
triggerall = stateno != 5401
triggerall = stateno != 5040
triggerall = stateno != [5200,5201]
triggerall = anim != [5101,5120]
triggerall = stateno != [5100,5120]
triggerall = var(58) > 0 
trigger1 = command = "Breaker"

;---------------------------------------------------------------------------
;Bullet Fury
[State -1, Bullet Fury]
type = ChangeState
value = 3000
triggerall = !var(59)
triggerall = command = "TripleKFPalm"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3200)
trigger2 = movecontact

;---------------------------------------------------------------------------
;Fake Gamma Charge
[State -1, Fake Gamma Charge]
type = ChangeState
value = 3100
triggerall = !var(59)
triggerall = command = "QCF_ab"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3200)
trigger2 = movecontact

;---------------------------------------------------------------------------
;Suicide Bombing
[State -1, Suicide Bombing]
type = ChangeState
value = 3200
triggerall = !var(59)
triggerall = command = "Suicide Bombing"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3200)
trigger2 = movecontact

;---------------------------------------------------------------------------
;Yojimbo Slash
[State -1, Yojimbo Slash]
type = ChangeState
value = 1200
triggerall = !var(59)
triggerall = command = "Yojimbo Slash"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Yojimbo Slash
[State -1, Yojimbo Slash]
type = ChangeState
value = 1250
triggerall = !var(59)
triggerall = command = "Yojimbo Slash"
triggerall = statetype != A
trigger1 = stateno = 200 && movecontact
trigger2 = stateno = 420 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact ;&& animtime >= -20
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush

;---------------------------------------------------------------------------
;Gunfire 1
[State -1, Gunfire 1]
type = ChangeState
value = 1000
triggerall = !var(59)
triggerall = command = "QCF_x"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 200 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush

;---------------------------------------------------------------------------
;Gunfire 2
[State -1, Gunfire 2]
type = ChangeState
value = 1010
triggerall = !var(59)
triggerall = command = "QCF_y"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Gunfire 3
[State -1, Gunfire 3]
type = ChangeState
value = 1020
triggerall = !var(59)
triggerall = command = "QCF_z"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 420 && animtime = -1

;---------------------------------------------------------------------------
;Surprise!
[State -1, Surprise!]
type = ChangeState
value = 1100
triggerall = !var(59)
triggerall = command = "Surprise!"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Surprise!
[State -1, Surprise!]
type = ChangeState
value = 280
triggerall = !var(59)
triggerall = command = "Surprise!"
trigger1 = stateno = [200,210]
trigger1 = movecontact
trigger2 = stateno = [230,240]
trigger2 = movecontact
trigger3 = stateno = 220 && movecontact && time >= 26
trigger4 = stateno = 250 && movecontact


;---------------------------------------------------------------------------
;Teleport Left
[State -1, Teleport Left]
type = ChangeState
value = 1300
triggerall = !var(59)
triggerall = command = "Teleport Left"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Teleport Med
[State -1, Teleport Med]
type = ChangeState
value = 1310
triggerall = !var(59)
triggerall = command = "Teleport Med"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Teleport Right
[State -1, Teleport Right]
type = ChangeState
value = 1320
triggerall = !var(59)
triggerall = command = "Teleport Right"
trigger1 = ctrl = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Air Bomb
[State -1, Teleport Right]
type = ChangeState
value = 1400
triggerall = !var(59)
triggerall = command = "Air Bomb"
trigger1 = ctrl = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Air Bomb
[State -1, Teleport Right]
type = ChangeState
value = 1400
triggerall = !var(59)
triggerall = command = "Air Bomb"
trigger1 = ctrl = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Weight Smash
[State -1, Weight Smash]
type = ChangeState
value = 1600
triggerall = !var(59)
triggerall = command = "Teleport Right" || command = "Teleport Med" || command = "Teleport Left"
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 && movecontact
trigger3 = stateno = 630 && movecontact
trigger4 = stateno = 610 && movecontact
trigger5 = stateno = 640 && movecontact

;---------------------------------------------------------------------------
;Magnum 1 (Overhead Attack)
[State -1, Magnum 1]
type = ChangeState
value = 260
triggerall = !var(59)
triggerall = command = "Magnum 1"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 440 && movecontact && animtime >= -17

;---------------------------------------------------------------------------
;Magnum 2
[State -1, Magnum 2]
type = ChangeState
value = 1500
triggerall = !var(59)
triggerall = command = "Magnum 2"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 200 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush

;---------------------------------------------------------------------------
;Magnum 3
[State -1, Magnum 3]
type = ChangeState
value = 1510
triggerall = !var(59)
triggerall = command = "Magnum 3"
trigger1 = ctrl = 1
trigger1 = statetype = S
trigger2 = stateno = 200 && movecontact
trigger3 = stateno = 210 && movecontact
trigger4 = stateno = 400 && movecontact
trigger5 = stateno = 410 && movecontact
trigger6 = stateno = 230 && movecontact
trigger7 = stateno = 220 && movecontact && animtime >= -40
trigger8 = stateno = 250 && movecontact
trigger9 = stateno = 220
trigger9 = moveguarded 
trigger9 = enemynear,stateno != [150,155] ;Pausetime Cancelled by GardPush


;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
;_bV
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = !var(59)
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
;ރ_bV
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = !var(59)
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Guard Push_G (Near)
[State -1, Guard Push_G]
type = ChangeState
value = 465
triggerall = !var(59)
triggerall = statetype != A
triggerall = (stateno = [150,155]) ;&& ctrl = 0
trigger1 = command = "GuardPush1"
ignorehitpause = 1

;---------------------------------------------------------------------------
;Guard Push_G (Far)
[State -1, Guard Push_G]
type = ChangeState
value = 466
triggerall = !var(59)
triggerall = statetype != A
triggerall = (stateno = [150,155]) ;&& ctrl = 0
trigger1 = command = "GuardPush2"
ignorehitpause = 1

;===========================================================================
;---------------------------------------------------------------------------
[State -1, Throw]
type = ChangeState
triggerall = !var(59)
triggerall = (command = "z")
triggerall = (StateNo != 100)
trigger1 = (command = "holdfwd") || (command = "holdback")
trigger1 = (StateType != A)
trigger1 = (Ctrl)
trigger1 = (P2BodyDist X < 8)
trigger1 = (P2StateType != A)
trigger1 = (P2MoveType != H)
value = 800

;---------------------------------------------------------------------------
;Stand_X
[State -1, Stand_X]
type = ChangeState
value = 200
triggerall = !var(59)
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand_Y
[State -1, Stand_Y]
type = ChangeState
value = 210
triggerall = !var(59)
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact
trigger3 = stateno = 230
trigger3 = movecontact
;trigger4 = stateno = 400 && movecontact

;---------------------------------------------------------------------------
;Stand_Z
[State -1, Stand_Z]
type = ChangeState
value = 220
triggerall = !var(59)
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = [200,210]
trigger2 = movecontact
trigger3 = stateno = 410 || stateno = 400 || stateno = 430 || stateno = 240
trigger3 = movecontact

;---------------------------------------------------------------------------
;Stand_A
[State -1, Stand_A]
type = ChangeState
value = 230
triggerall = !var(59)
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact

;---------------------------------------------------------------------------
;Stand_B
[State -1, Stand_B]
type = ChangeState
value = 240
triggerall = !var(59)
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 210 || stateno = 230 || stateno = 400 || stateno = 410 || stateno = 430
trigger2 = movecontact

;---------------------------------------------------------------------------
;Stand_C
[State -1, Stand_C]
type = ChangeState
value = 250
triggerall = !var(59)
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl 
trigger2 = (stateno = [200,210]) || stateno = 230 || stateno = 430
trigger2 = movecontact

;---------------------------------------------------------------------------
;440 => 255
[State -1, 255 (Hummer)]
type = ChangeState
value = 255
triggerall = !var(59)
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = stateno = 440 && movecontact

;---------------------------------------------------------------------------
;Crouch_X
[State -1, Crouch_X]
type = ChangeState
value = 400
triggerall = !var(59)
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = movecontact
trigger3 = stateno = 230
trigger3 = movecontact

;---------------------------------------------------------------------------
;Crouch_Y
[State -1, Crouch_Y]
type = ChangeState
value = 410
triggerall = !var(59)
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 400 && movecontact
trigger3 = stateno = 430 && movecontact
trigger4 = stateno = 230
trigger4 = movecontact
trigger5 = stateno = 200
trigger5 = movecontact

;---------------------------------------------------------------------------
;Crouch_Z
[State -1, Crouch_Z]
type = ChangeState
value = 420
triggerall = !var(59)
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 410
trigger2 = movecontact
trigger3 = stateno = 220
trigger3 = movecontact
trigger4 = stateno = 200
trigger4 = movecontact
trigger5 = stateno = 250
trigger5 = movecontact

;---------------------------------------------------------------------------
;Crouch_A
[State -1, Crouch_A]
type = ChangeState
value = 430
triggerall = !var(59)
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 400
trigger2 = movecontact
trigger3 = stateno = 200
trigger3 = movecontact
trigger4 = stateno = 230
trigger4 = movecontact

;---------------------------------------------------------------------------
;Crouch_B
[State -1, Crouch_B]
type = ChangeState
value = 440
triggerall = !var(59)
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 430
trigger2 = movecontact
trigger3 = stateno = 230
trigger3 = movecontact
trigger4 = stateno = [200,210]
trigger4 = movecontact
trigger5 = stateno = 410 && movecontact

;---------------------------------------------------------------------------
;Crouch_C
[State -1, Crouch_C]
type = ChangeState
value = 450
triggerall = !var(59)
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 440
trigger2 = movecontact
trigger3 = stateno = 250
trigger3 = movecontact
trigger4 = stateno = 220
trigger4 = movecontact

;---------------------------------------------------------------------------
;Air_X
[State -1, Air_X]
type = ChangeState
value = 600
triggerall = !var(59)
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Air_Y
[State -1, Air_Y]
type = ChangeState
value = 610
triggerall = !var(59)
triggerall = command = "y"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630
trigger2 = movecontact

;---------------------------------------------------------------------------
;Air_Z
[State -1, Air_Z]
type = ChangeState
value = 620
triggerall = !var(59)
triggerall = command = "z"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 610 || stateno = 640
trigger2 = movecontact


;---------------------------------------------------------------------------
;Air_A
[State -1, Air_A]
type = ChangeState
value = 630
triggerall = !var(59)
triggerall = command = "a"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = movecontact

;---------------------------------------------------------------------------
;Air_B
[State -1, Air_B]
type = ChangeState
value = 640
triggerall = !var(59)
triggerall = command = "b"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = stateno = 630
trigger2 = movecontact
trigger3 = stateno = 600
trigger3 = movecontact
trigger4 = stateno = 610
trigger4 = movecontact

;---------------------------------------------------------------------------
;Air_C
[State -1, Air_C]
type = ChangeState
value = 650
triggerall = !var(59)
triggerall = command = "c"
triggerall = statetype = A
trigger1 = ctrl
trigger2 = (stateno = [600,610]) || stateno = 640 || stateno = 630
trigger2 = movecontact

;---------------------------------------------------------------------------
;Super Jump Up
[State -1, Super Jump Up]
type = ChangeState
value = 60
triggerall = !var(59)
triggerall = command = "super_jump_up" && ctrl
trigger1 = statetype = S && statetype != A 
trigger2 = stateno = 10  
;-----------------------------
;Launcher
[State -1, Launcher] ;by GGN
type = ChangeState
value = 60
triggerall = !var(59)
triggerall = Command = "holdup"
trigger1 = stateno = 240 && movehit

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 196
triggerall = !var(59)
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;------------------------------------------------------------------------------
;Recover Rolls
[state -1, recover F]
type = changestate
value = 890
triggerall = !var(59) 
triggerall = RoundState = 2
triggerall = stateno = 5120
TriggerAll = alive 
trigger1 = command = "holdfwd"

[state -1, recover B]
type = changestate
value = 895
triggerall = !var(59) 
triggerall = RoundState = 2
triggerall = stateno = 5120
TriggerAll = alive 
trigger1 = command = "holdback"

;====
;AI
;====
